#ifndef APR_BUCKETS_USP_HPP_AKW
#define APR_BUCKETS_USP_HPP_AKW

#include <apu.h>
#include <apr.h>
#include <apr_buckets.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct bucket_t bucket_t;
typedef struct buckets_t buckets_t;

typedef struct request_rec request_rec;

extern const apr_bucket_type_t apr_bucket_type_usp;

apr_bucket*
apr_bucket_usp_make(apr_bucket* b, bucket_t* bucket, request_rec* request);

apr_bucket*
apr_bucket_usp_create(bucket_t* bucket, apr_bucket_alloc_t* list,
                      request_rec* request);

apr_status_t
apache_brigade_to_usp_buckets(apr_bucket_brigade* bb, buckets_t* buckets);

apr_status_t
usp_buckets_to_apache_brigade(buckets_t* buckets, apr_bucket_brigade* bb,
                              request_rec* request);

#ifdef __cplusplus
} /* extern C definitions */
#endif

#endif // APR_BUCKETS_USP_HPP_AKW

// End Of File

